package gov.va.med.mhv.mrp.web.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;

import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalExtensionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalPriorityTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalStatusTypeEnumeration;
import gov.va.med.mhv.mrp.enums.HourEnumeration;
import gov.va.med.mhv.mrp.enums.MinuteEnumeration;

@ManagedBean
@ApplicationScoped
public class MyGoalsConstants implements Serializable {	
	private static final long serialVersionUID = 1L;
	
	private List<String> categories = new ArrayList<String>();
	
	@PostConstruct
	private void init() {
		categories.add("Finance");
		categories.add("Living Situation");
		categories.add("Work");
		categories.add("Health");
		categories.add("Spirituality");
		categories.add("Leisure Activity");
		categories.add("Relationships");
		categories.add("Learning");
		categories.add("Other");
	}
	
	public GoalCompletionTypeEnumeration[] getGoalCompletionTypeEnumeration() {
		return GoalCompletionTypeEnumeration.values();
	}
	
	public GoalExtensionTypeEnumeration[] getGoalExtensionTypeEnumeration() {
		return GoalExtensionTypeEnumeration.values();
	}

	public GoalPriorityTypeEnumeration[] getGoalPriorityTypeEnumeration() {
		return GoalPriorityTypeEnumeration.values();
	}

	public GoalStatusTypeEnumeration[] getGoalStatusTypeEnumeration() {
		return GoalStatusTypeEnumeration.values();
	}

	public HourEnumeration[] getHourEnumeration() {
		return HourEnumeration.values();
	}

	public MinuteEnumeration[] getMinuteEnumeration() {
		return MinuteEnumeration.values();
	}

	public List<String> getCategories() {
		return categories;
	}
	
}
